/*


    Evolute version 0.7
    Copyright (C) 2010 Antti Vainio

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

//NOTE: the source code is written in Finnish, so if you don't understand it, just throw it trough Google translator or something

//          main.cpp


//Windows versio on knnetty MinGW:ll, Linux version Makefile knt GCC:ll
//joten koodi toimii ainakin noilla kntjill

//MinGW:ss linkeriin tulee:
            //-lmingw32 -lSDLmain -lSDL -lSDL_gfx -lSDL_image -lpng -lz -lSDL_mixer

//Tlt lytyy SDL:n alustus ja lataaminen

//Tss on kaikkien tmn tiedoston tarvitsemien kirjastojen lisksi esitelty muut pelin tarvitsemat kirjastot
//#include <stdio.h> // GLOBAALI
#include <stdlib.h>
//#include <string.h>
//#include <SDL/SDL.h> //SDL - GLOBAALI
//#include <SDL/SDL_image.h> //SDL_image (ja libpng sek zlib)
#include <SDL/SDL_rotozoom.h> //SDL_gfx
//#include <SDL/SDL_mixer.h> //SDL_mixer - GLOBAALI
//#include <windows.h> //messageboxeja varten (tm on kytss asetustenlataus.cpp ja funktioita.cpp tiedostoissa)
//#include <dirent.h> //kansion sislln tutkiminen - tm on kytss vain custommapit.cpp:ss - tm ei luultavasta toimi Microsoft Visual C++:ssa
#include <math.h>
#include <time.h>
#include "global.hpp"
#include "main.hpp" //oma headeritiedosto

//koko paska voi tiltata jos:
       //jaetaan nollalla
       //piirretn pikseli ruudun ulkopuolelle
       //yritetn piirt taso, jota ei ole
       //yritetn piirt taso, johon on ladattu kuva, jota ei ole

int main(int argc, char *argv[]) {
    #ifndef _WIN32
           logtiedosto = fopen("log.txt", "w");
           if(logtiedosto == NULL) { //tiedostoa ei voinut avata
                  log("Couldn't create log file");
           }
    #endif
    log("Game started");
    
//ALUSTETAAN SDL
    if (SDL_Init (SDL_INIT_AUDIO|SDL_INIT_VIDEO) < 0)
    {
        sprintf (viesti, "Couldn't initialize SDL: %s\n", SDL_GetError ());
        naytavirhe(viesti);
        exit (1);
    }
    atexit (SDL_Quit);
    
    //asetetaan ikoni
    if(SDL_Surface *ikoni = SDL_LoadBMP("images/icon.bmp")) {
              SDL_WM_SetIcon(ikoni, NULL);
              SDL_FreeSurface(ikoni);
    }
    else { //virhe!
              sprintf(viesti, "%s", SDL_GetError ());
              naytavirhe(viesti);
    }
    
    lataafsasetus(); //ladataan asetus fullscreenille
    if(fullscreen == 0) ruutu = SDL_SetVideoMode (800, 600, 32, SDL_HWSURFACE | SDL_DOUBLEBUF);
    else ruutu = SDL_SetVideoMode (800, 600, 32, SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_FULLSCREEN);
    if (ruutu == NULL) {
        sprintf (viesti, "Couldn't set 800x600x32 video mode: %s\n", SDL_GetError ());
        naytavirhe(viesti);
        exit (2);
    }
    
    SDL_WM_SetCaption("Evolute", "Evolute");
    
    int audio_rate = 22050;
    Uint16 audio_format = MIX_DEFAULT_FORMAT;
    int audio_channels = 1;
    
    if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, 1024)==-1) {
        sprintf (viesti, "Couldn't initialize SDL_Mixer: %s\n", Mix_GetError());
        naytavirhe(viesti);
        exit (1);
    }
    
    if(Mix_QuerySpec(&audio_rate, &audio_format, &audio_channels)==0) {
        sprintf (viesti, "Mix_QuerySpec: %s\n", Mix_GetError());
        naytavirhe(viesti);
        exit (1);
    }
    
    Mix_AllocateChannels(16);
    
    log("SDL Initialized");
//SDL ALUSTETTU

      SDL_ShowCursor(0);      //piilotetaan hiiri



//------------------------------
//                              LOADING:                 ------------------------------
//------------------------------

      alkuaika = SDL_GetTicks();
      
      log("Loading game");
      
      //alustetaan satunnaisluvut
      time_t siemen;
      time(&siemen);
      srand(siemen);
      
      int i, j, k, l;
      float floati;
      
      valkoinen = SDL_MapRGB(ruutu->format, 255, 255, 255);
      
      //tempruudut
      SDL_Surface *tempruutu_temp = SDL_CreateRGBSurface( SDL_HWSURFACE, 800, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000); //niss ei ole alphakanavaa
      SDL_Surface *tempruutu2_temp = SDL_CreateRGBSurface( SDL_HWSURFACE, 800, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      SDL_Surface *tempruutuesc_temp = SDL_CreateRGBSurface( SDL_HWSURFACE, 800, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      SDL_Surface *temptausta_temp = SDL_CreateRGBSurface( SDL_HWSURFACE, 500, 550, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      tempruutu = optimoi(tempruutu_temp);
      tempruutu2 = optimoi(tempruutu2_temp);
      tempruutuesc = optimoi(tempruutuesc_temp);
      temptausta = optimoi(temptausta_temp);
      
      //loading ruutu
      lataus = lataapng("images/loading.png");
      latauspalkki = lataapng("images/loadingbar.png");
      
      piirtokohta = tempruutu; //piirretn mys thn, koska tt tarvitaan loppufadessa
      SDL_FillRect(tempruutu, NULL, valkoinen);
      piirrakuva(lataus, 400, 200);
      piirrakuva(latauspalkki, 400, 375);
      Uint32 latauspalkkivari = SDL_MapRGB(tempruutu->format, 255, 255, 65); //tm vri pit tarkistaa erikseen
      SDL_Rect latauspalkkikohta;
      latauspalkkikohta.x = 153;
      latauspalkkikohta.y = 353;
      latauspalkkikohta.w = 494;
      latauspalkkikohta.h = 44;
      SDL_FillRect(tempruutu, &latauspalkkikohta, latauspalkkivari);
      
      piirtokohta = ruutu;
      SDL_FillRect(ruutu, NULL, valkoinen);
      piirrakuva(lataus, 400, 200);
      piirrakuva(latauspalkki, 400, 375);
      SDL_Flip(ruutu);
      
      //ladataan asetukset
      lataaasetukset();
      lataagfxasetukset();
      
      //vrej ja fadeja
      //reddottia kytetn ympyrthtimess
      reddot = SDL_CreateRGBSurface( SDL_HWSURFACE, 1, 1, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      Uint32 reddotvari = SDL_MapRGB(reddot->format, gfxpistevari[0], gfxpistevari[1], gfxpistevari[2]);
      SDL_FillRect(reddot, NULL, reddotvari);
      
      SDL_Surface *raakamustafade = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, 800, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
      Uint32 mustafadevari = SDL_MapRGB(raakamustafade->format, 0, 0, 0);
      SDL_FillRect(raakamustafade, NULL, mustafadevari);
      mustafade = optimoi(raakamustafade);
      
      SDL_Surface *raakavalkoinenfade = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, 800, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
      Uint32 valkoinenfadevari = SDL_MapRGB(raakavalkoinenfade->format, 255, 255, 255);
      SDL_FillRect(raakavalkoinenfade, NULL, valkoinenfadevari);
      valkoinenfade = optimoi(raakavalkoinenfade);
      
      latausruutu(2);   // LATAUSRUUTU
      
               //LADATAAN NET
      pelimusiikki = lataamusiikki("sounds/Delight Progression.mp3");
      menuintromusiikki = lataamusiikki("sounds/menu intro.mp3");
      menumusiikki = lataamusiikki("sounds/menu.mp3");
      ampu = lataaaani("sounds/soundeffects/shot.wav");
      ampu2 = lataaaani("sounds/soundeffects/shot2.wav");
      loppubasso = lataaaani("sounds/soundeffects/bass.wav");
      gameoverhit = lataaaani("sounds/soundeffects/gameover.wav");
      tick = lataaaani("sounds/soundeffects/tick.wav");
      splat1 = lataaaani("sounds/soundeffects/splat1.wav");
      splat2 = lataaaani("sounds/soundeffects/splat2.wav");
      splat3 = lataaaani("sounds/soundeffects/splat3.wav");
      splat4 = lataaaani("sounds/soundeffects/splat4.wav");
      hit = lataaaani("sounds/soundeffects/hit.wav");
      hitzap = lataaaani("sounds/soundeffects/hitzap.wav");
      levelup = lataaaani("sounds/soundeffects/levelup.wav");
      kauppaaani = lataaaani("sounds/soundeffects/shop.wav");
      nappi1 = lataaaani("sounds/soundeffects/button1.wav");
      nappi2 = lataaaani("sounds/soundeffects/button2.wav");
      nappion = lataaaani("sounds/soundeffects/buttonon.wav");
      
      latausruutu(5);   // LATAUSRUUTU
      
               //LADATAAN KUVIA
      slpash = lataapng("images/mouse-only_game.png");
      tausta = lataapng("images/background.png");
      taustaframe = lataapngalpha("images/background_frame.png");
      taustavasen = lataapng("images/background_left.png");
      taustaoikea = lataapng("images/background_right.png");
      taustaala = lataapng("images/background_bottom.png");
      taustavasen2 = lataapngalpha("images/background_left2.png");
      taustaoikea2 = lataapngalpha("images/background_right2.png");
      taustaala2 = lataapngalpha("images/background_bottom2.png");
      fpslaatikko = lataapng("images/fps.png");
      debugnumerot = lataapng("images/debugnumbers.png");
      SDL_SetColorKey(debugnumerot, SDL_SRCCOLORKEY, valkoinen);
      numerot = lataapngalpha("images/commonnumbers.png");
      fontti[0] = lataapngalpha("images/font.png"); //alkuperinen koko 29x48
      fontti[1] = zoomSurface(fontti[0], 0.6551724138, 0.6458333333, 1); //19x31
      fontti[2] = zoomSurface(fontti[0], 0.2413793103, 0.2500000000, 1); //7x12
      fontti[3] = zoomSurface(fontti[0], 0.3448275862, 0.3541666667, 1); //10x17
      //partikkelit
      partikkeli1[0] = lataapngalpha("images/particle1.png");
      partikkeli1[1] = zoomSurface(partikkeli1[0], 0.8, 0.8, 1);
      partikkeli1[2] = zoomSurface(partikkeli1[0], 0.4, 0.4, 1);
      partikkeli2[0] = lataapngalpha("images/particle2.png");
      for(i=1;i<=4;i++) partikkeli2[i] = zoomSurface(partikkeli2[0], 1 - 0.2 * i, 1 - 0.2 * i, 1);
      partikkeli3 = lataapngalpha("images/particle3.png");
      //spritet
      nappipeliexit1 = lataapngalpha("images/game_exit1.png");
      nappipeliexit2 = lataapngalpha("images/game_exit2.png");
      aikasurvival = lataapngalpha("images/time_survival.png");
      aikajakaja = lataapngalpha("images/time_separator.png");
      aikaboss = lataapngalpha("images/time_boss.png");
      elamatkuva = lataapngalpha("images/lives.png");
      elamakuva = lataapng("images/life.png");
      tykkikuva1 = lataapngalpha("images/cannon.png");
      tykkialusta = lataapngalpha("images/cannonbase.png");
      tykkitulikuva1[0][0] = lataapngalpha("images/flame1.png");
      tykkitulikuva1[1][0] = lataapngalpha("images/flame2.png");
      tykkitulikuva1[2][0] = lataapngalpha("images/flame3.png");
      panoskuva = lataapngalpha("images/bullet.png");
      panoscritkuva = lataapngalpha("images/bulletcrit.png");
      pelitahtain = lataapngalpha("images/gamecursor.png");
      menutahtain = lataapngalpha("images/menucursor.png");
      crittahtain = lataapngalpha("images/critcrosshair.png");
      efektikuvakeltainen2 = lataapngalpha("images/yelloweffect.png");
      efektikuvapunainen2 = lataapngalpha("images/redeffect.png");
      vihukuva2[0] = lataapngalpha("images/enemy1.png");
      vihukuva2[1] = lataapngalpha("images/enemy2.png");
      vihukuva2[2] = lataapngalpha("images/enemy3.png");
      vihukuva2[3] = lataapngalpha("images/enemy7.png");
      vihukuva2keltainen = lataapngalpha("images/enemy4.png");
      vihukuvamusta = lataapngalpha("images/enemy5.png");
      vihukuva2nopea = lataapngalpha("images/enemy6.png");
      vihukuva7 = lataapngalpha("images/enemy8.png");
      splatterkuva2[0] = lataapngalpha("images/enemysplatter1.png");
      splatterkuva2[1] = lataapngalpha("images/enemysplatter2.png");
      splatterkuva2[2] = lataapngalpha("images/enemysplatter3.png");
      splatterkuva2[3] = lataapngalpha("images/enemysplatter4.png");
      splatterkuva2[4] = lataapngalpha("images/enemysplatter7.png");
      splatterkuva2musta = lataapngalpha("images/enemysplatter5.png");
      splatterkuva2nopea = lataapngalpha("images/enemysplatter6.png");
      vihukuollutkuva2[0] = lataapngalpha("images/deadenemy1.png");
      vihukuollutkuva2[1] = lataapngalpha("images/deadenemy2.png");
      vihukuollutkuva2[2] = lataapngalpha("images/deadenemy3.png");
      vihukuollutkuva2[3] = lataapngalpha("images/deadenemy4.png");
      vihukuollutkuva2[4] = lataapngalpha("images/deadenemy7.png");
      vihukuollutkuva2musta = lataapngalpha("images/deadenemy5.png");
      vihukuollutkuva2nopea = lataapngalpha("images/deadenemy6.png");
      vihukuollutkuva7 = lataapngalpha("images/deadenemy8.png");
      
      //expat ja levut
      expnumerot = lataapng("images/expnumbers.png");
      expnumerot_red = lataapng("images/expnumbers_red.png");
      exppalkkityhja = lataapng("images/expbar_empty.png");
      for(i=0;i<=13;i++) exppalkki[i] = lataapng("images/expbar.png");
      exppalkki[14] = lataapng("images/expbar_empty.png");
      piirraexpluku(levuraja[0], 20);
      piirraexpluku(levuraja[1], 21);
      piirraexpluku(levuraja[2], 22);
      piirraexpluku(levuraja[3], 23);
      piirraexpluku(levuraja[4], 24);
      piirraexpluku(peruslevuraja[0], 25);
      piirraexpluku(peruslevuraja[1], 26);
      piirraexpluku(peruslevuraja[2], 27);
      piirraexpluku(peruslevuraja[3], 28);
      piirraexpluku(peruslevuraja[4], 29);
      piirraexpluku(peruslevuraja[5], 30);
      piirraexpluku(peruslevuraja[6], 31);
      piirraexpluku(peruslevuraja[7], 32);
      piirraexpluku(peruslevuraja[8], 33);
      levelikuva[0] = lataapng("images/level0.png");
      levelikuva[1] = lataapng("images/level1.png");
      levelikuva[2] = lataapng("images/level2.png");
      levelikuva[3] = lataapng("images/level3.png");
      levelikuva[4] = lataapng("images/level4_2.png");
      levelikuva[5] = lataapng("images/level5_2.png");
      levelikuva3 = lataapng("images/level3_2.png");
      peruslevelikuva[0] = lataapng("images/level4.png");
      peruslevelikuva[1] = lataapng("images/level5.png");
      peruslevelikuva[2] = lataapng("images/level6.png");
      peruslevelikuva[3] = lataapng("images/level7.png");
      peruslevelikuva[4] = lataapng("images/level8.png");
      peruslevelikuva[5] = lataapng("images/level9.png");
      expnumerot2 = lataapngalpha("images/expnumbers2.png");
      expnumerot_100 = lataapngalpha("images/expnumber_100.png");
      expnumerot_400 = lataapngalpha("images/expnumber_400.png");
      expnumerot_1 = lataapngalpha("images/expnumber_1.png");
      //kauppa
      kauppatausta = lataapng("images/shop_background.png");
      kauppanappi1 = lataapngalpha("images/buy1.png");
      kauppanappi2 = lataapngalpha("images/buy2.png");
      kauppanappi3 = lataapngalpha("images/buy3.png");
      kauppateksti = lataapngalpha("images/1000freexp.png");
      SDL_Surface *kauppakuva_temp = SDL_CreateRGBSurface( SDL_HWSURFACE, 400, 400, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      kauppakuva = optimoi(kauppakuva_temp);
      menutausta = lataapng("images/menu_background.png");
      //esc-menu
      escmenutausta = lataapng("images/esc_background.png");
      escmenuteksti = lataapngalpha("images/exit.png");
      escmenunappi1 = lataapngalpha("images/esc_button_continue1.png");
      escmenunappi2 = lataapngalpha("images/esc_button_continue2.png");
      escmenunappi3 = lataapngalpha("images/esc_button_menu1.png");
      escmenunappi4 = lataapngalpha("images/esc_button_menu2.png");
      otsikko = lataapngalpha("images/menu_logo.png");
      //stagen loppuruutu
      stageplaynext = lataapngalpha("images/playnextstage.png");
      stageretry = lataapngalpha("images/retry.png");
      stagecompleted = lataapngalpha("images/completed.png");
      //napit
      nappitakaisin2 = lataapngalpha("images/button_back2.png");
      nappitakaisin[0] = lataapngalpha("images/button_back1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) nappitakaisin[1] = rotozoomSurface(nappitakaisin2, floati / 5 + 1, 1.1, 1);
      else nappitakaisin[1] = rotozoomSurface(nappitakaisin2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) nappitakaisin[2] = rotozoomSurface(nappitakaisin2, floati / 5 + 1, 0.9, 1);
      else nappitakaisin[2] = rotozoomSurface(nappitakaisin2, 0 - (floati / 5 + 1), 0.9, 1);
      nappimoreu2 = lataapngalpha("images/button_moreu2.png");
      nappimoreu[0] = lataapngalpha("images/button_moreu.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) nappimoreu[1] = rotozoomSurface(nappimoreu2, floati / 5 + 1, 1.1, 1);
      else nappimoreu[1] = rotozoomSurface(nappimoreu2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) nappimoreu[2] = rotozoomSurface(nappimoreu2, floati / 5 + 1, 0.9, 1);
      else nappimoreu[2] = rotozoomSurface(nappimoreu2, 0 - (floati / 5 + 1), 0.9, 1);
      nappimored2 = lataapngalpha("images/button_mored2.png");
      nappimored[0] = lataapngalpha("images/button_mored.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) nappimored[1] = rotozoomSurface(nappimored2, floati / 5 + 1, 1.1, 1);
      else nappimored[1] = rotozoomSurface(nappimored2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) nappimored[2] = rotozoomSurface(nappimored2, floati / 5 + 1, 0.9, 1);
      else nappimored[2] = rotozoomSurface(nappimored2, 0 - (floati / 5 + 1), 0.9, 1);
      nappipelaa2 = lataapngalpha("images/button_play2.png");
      nappipelaa[0] = lataapngalpha("images/button_play1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) nappipelaa[1] = rotozoomSurface(nappipelaa2, floati / 5 + 1, 1.1, 1);
      else nappipelaa[1] = rotozoomSurface(nappipelaa2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) nappipelaa[2] = rotozoomSurface(nappipelaa2, floati / 5 + 1, 0.9, 1);
      else nappipelaa[2] = rotozoomSurface(nappipelaa2, 0 - (floati / 5 + 1), 0.9, 1);
      nappiscores2 = lataapngalpha("images/button_hiscores2.png");
      nappiscores[0] = lataapngalpha("images/button_hiscores1.png");
      nappiscores[3] = lataapngalpha("images/button_hiscores3.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) nappiscores[1] = rotozoomSurface(nappiscores2, floati / 5 + 1, 1.1, 1);
      else nappiscores[1] = rotozoomSurface(nappiscores2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) nappiscores[2] = rotozoomSurface(nappiscores2, floati / 5 + 1, 0.9, 1);
      else nappiscores[2] = rotozoomSurface(nappiscores2, 0 - (floati / 5 + 1), 0.9, 1);
      statscontinue2 = lataapngalpha("images/stats_continue2.png");
      statscontinue[0] = lataapngalpha("images/stats_continue1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) statscontinue[1] = rotozoomSurface(statscontinue2, floati / 5 + 1, 1.1, 1);
      else statscontinue[1] = rotozoomSurface(statscontinue2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) statscontinue[2] = rotozoomSurface(statscontinue2, floati / 5 + 1, 0.9, 1);
      else statscontinue[2] = rotozoomSurface(statscontinue2, 0 - (floati / 5 + 1), 0.9, 1);
      tutorialcontinue2 = lataapngalpha("images/tutorial_continue2.png");
      tutorialcontinue[0] = lataapngalpha("images/tutorial_continue1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) tutorialcontinue[1] = rotozoomSurface(tutorialcontinue2, floati / 5 + 1, 1.1, 1);
      else tutorialcontinue[1] = rotozoomSurface(tutorialcontinue2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) tutorialcontinue[2] = rotozoomSurface(tutorialcontinue2, floati / 5 + 1, 0.9, 1);
      else tutorialcontinue[2] = rotozoomSurface(tutorialcontinue2, 0 - (floati / 5 + 1), 0.9, 1);
      stageyes2 = lataapngalpha("images/button_yes2.png");
      stageyes[0] = lataapngalpha("images/button_yes1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) stageyes[1] = rotozoomSurface(stageyes2, floati / 5 + 1, 1.1, 1);
      else stageyes[1] = rotozoomSurface(stageyes2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) stageyes[2] = rotozoomSurface(stageyes2, floati / 5 + 1, 0.9, 1);
      else stageyes[2] = rotozoomSurface(stageyes2, 0 - (floati / 5 + 1), 0.9, 1);
      stageno2 = lataapngalpha("images/button_no2.png");
      stageno[0] = lataapngalpha("images/button_no1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) stageno[1] = rotozoomSurface(stageno2, floati / 5 + 1, 1.1, 1);
      else stageno[1] = rotozoomSurface(stageno2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) stageno[2] = rotozoomSurface(stageno2, floati / 5 + 1, 0.9, 1);
      else stageno[2] = rotozoomSurface(stageno2, 0 - (floati / 5 + 1), 0.9, 1);
      stageok2 = lataapngalpha("images/button_ok2.png");
      stageok[0] = lataapngalpha("images/button_ok1.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) stageok[1] = rotozoomSurface(stageok2, floati / 5 + 1, 1.1, 1);
      else stageok[1] = rotozoomSurface(stageok2, 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) stageok[2] = rotozoomSurface(stageok2, floati / 5 + 1, 0.9, 1);
      else stageok[2] = rotozoomSurface(stageok2, 0 - (floati / 5 + 1), 0.9, 1);
      menunappinew1 = lataapngalpha("images/menu_button_new1.png");
      menunappinew2[0] = lataapngalpha("images/menu_button_new2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappinew2[1] = rotozoomSurface(menunappinew2[0], floati / 5 + 1, 1.1, 1);
      else menunappinew2[1] = rotozoomSurface(menunappinew2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappinew2[2] = rotozoomSurface(menunappinew2[0], floati / 5 + 1, 0.9, 1);
      else menunappinew2[2] = rotozoomSurface(menunappinew2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappiscores1 = lataapngalpha("images/menu_button_scores1.png");
      menunappiscores2[0] = lataapngalpha("images/menu_button_scores2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappiscores2[1] = rotozoomSurface(menunappiscores2[0], floati / 5 + 1, 1.1, 1);
      else menunappiscores2[1] = rotozoomSurface(menunappiscores2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappiscores2[2] = rotozoomSurface(menunappiscores2[0], floati / 5 + 1, 0.9, 1);
      else menunappiscores2[2] = rotozoomSurface(menunappiscores2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappisettings1 = lataapngalpha("images/menu_button_settings1.png");
      menunappisettings2[0] = lataapngalpha("images/menu_button_settings2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappisettings2[1] = rotozoomSurface(menunappisettings2[0], floati / 5 + 1, 1.1, 1);
      else menunappisettings2[1] = rotozoomSurface(menunappisettings2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappisettings2[2] = rotozoomSurface(menunappisettings2[0], floati / 5 + 1, 0.9, 1);
      else menunappisettings2[2] = rotozoomSurface(menunappisettings2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappicredits1 = lataapngalpha("images/menu_button_credits1.png");
      menunappicredits2[0] = lataapngalpha("images/menu_button_credits2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappicredits2[1] = rotozoomSurface(menunappicredits2[0], floati / 5 + 1, 1.1, 1);
      else menunappicredits2[1] = rotozoomSurface(menunappicredits2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappicredits2[2] = rotozoomSurface(menunappicredits2[0], floati / 5 + 1, 0.9, 1);
      else menunappicredits2[2] = rotozoomSurface(menunappicredits2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappiexit1 = lataapngalpha("images/menu_button_exit1.png");
      menunappiexit2[0] = lataapngalpha("images/menu_button_exit2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappiexit2[1] = rotozoomSurface(menunappiexit2[0], floati / 5 + 1, 1.1, 1);
      else menunappiexit2[1] = rotozoomSurface(menunappiexit2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappiexit2[2] = rotozoomSurface(menunappiexit2[0], floati / 5 + 1, 0.9, 1);
      else menunappiexit2[2] = rotozoomSurface(menunappiexit2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappitutorial1 = lataapngalpha("images/menu_button_tutorial1.png");
      menunappitutorial2[0] = lataapngalpha("images/menu_button_tutorial2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappitutorial2[1] = rotozoomSurface(menunappitutorial2[0], floati / 5 + 1, 1.1, 1);
      else menunappitutorial2[1] = rotozoomSurface(menunappitutorial2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappitutorial2[2] = rotozoomSurface(menunappitutorial2[0], floati / 5 + 1, 0.9, 1);
      else menunappitutorial2[2] = rotozoomSurface(menunappitutorial2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappistages1 = lataapngalpha("images/menu_button_stages1.png");
      menunappistages2[0] = lataapngalpha("images/menu_button_stages2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappistages2[1] = rotozoomSurface(menunappistages2[0], floati / 5 + 1, 1.1, 1);
      else menunappistages2[1] = rotozoomSurface(menunappistages2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappistages2[2] = rotozoomSurface(menunappistages2[0], floati / 5 + 1, 0.9, 1);
      else menunappistages2[2] = rotozoomSurface(menunappistages2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappisurvival1 = lataapngalpha("images/menu_button_survival1.png");
      menunappisurvival2[0] = lataapngalpha("images/menu_button_survival2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappisurvival2[1] = rotozoomSurface(menunappisurvival2[0], floati / 5 + 1, 1.1, 1);
      else menunappisurvival2[1] = rotozoomSurface(menunappisurvival2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappisurvival2[2] = rotozoomSurface(menunappisurvival2[0], floati / 5 + 1, 0.9, 1);
      else menunappisurvival2[2] = rotozoomSurface(menunappisurvival2[0], 0 - (floati / 5 + 1), 0.9, 1);
      menunappicustommap1 = lataapngalpha("images/menu_button_custom1.png");
      menunappicustommap2[0] = lataapngalpha("images/menu_button_custom2.png");
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappicustommap2[1] = rotozoomSurface(menunappicustommap2[0], floati / 5 + 1, 1.1, 1);
      else menunappicustommap2[1] = rotozoomSurface(menunappicustommap2[0], 0 - (floati / 5 + 1), 1.1, 1);
      floati = rand() % 11;
      if(rand() % 2 == 0) menunappicustommap2[2] = rotozoomSurface(menunappicustommap2[0], floati / 5 + 1, 0.9, 1);
      else menunappicustommap2[2] = rotozoomSurface(menunappicustommap2[0], 0 - (floati / 5 + 1), 0.9, 1);
      mappinappi0 = lataapngalpha("images/button_map0.png");
      mappinappilock = lataapng("images/button_maplock.png");
      mappinappiok = lataapngalpha("images/ok.png");
      mappinappi[0] = lataapng("images/button_map1.png");
      mappinappi[1] = lataapng("images/button_map2.png");
      mappinappi[2] = lataapng("images/button_map3.png");
      mappinappi[3] = lataapng("images/button_map4.png");
      mappinappi[4] = lataapng("images/button_map5.png");
      mapnappifade = lataapngalpha("images/buttonmapfade.png");
      //stats
      statsteksti = lataapngalpha("images/stats.png");
      statsdash = lataapngalpha("images/stats_dash.png");
      statsscore = lataapngalpha("images/stats_score.png");
      statsmasterpiece1 = lataapngalpha("images/stats_masterpiece1.png");
      statsmasterpiece2 = lataapngalpha("images/stats_masterpiece2.png");
      //game over
      SDL_Surface *tempgameoverfade = SDL_CreateRGBSurface( SDL_HWSURFACE, 1300, 600, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
      Uint32 gameovervari = SDL_MapRGB(tempgameoverfade->format, 0, 0, 0);
      SDL_FillRect(tempgameoverfade, NULL, gameovervari);
      SDL_Surface *gameoverympyra = lataapng("images/circle.png");
      piirtokohta = tempgameoverfade;
      piirrakuva(gameoverympyra, 650, 540);
      piirtokohta = ruutu;
      gameoverfade = optimoi(tempgameoverfade);
      SDL_FreeSurface(gameoverympyra);
      SDL_SetColorKey(gameoverfade, SDL_SRCCOLORKEY, valkoinen);
      gameoverteksti = lataapngalpha("images/game_over.png");
      gameoverrikki = lataapngalpha("images/background_broken.png");
      //newhiscore
      newhstausta = lataapng("images/esc_background.png");
      newhspalkki = lataapng("images/newhiscorebar.png");
      newhsteksti = lataapngalpha("images/newhiscore.png");
      newhstype = lataapngalpha("images/newhiscoretype.png");
      piirtokohta = newhstausta;
      piirrakuva(newhsteksti, 200, 35);
      piirrakuva2(newhspalkki, 50, 75);
      piirtokohta = ruutu;
      //settings
      settingstekstit = lataapngalpha("images/settings.png");
      settingspalkki1 = lataapngalpha("images/settingsbar.png");
      settingspalkki2 = lataapngalpha("images/settingsbar2.png");
      settingsboth1 = lataapngalpha("images/settings_both1.png");
      settingsboth2 = lataapngalpha("images/settings_both2.png");
      settingscircle1 = lataapngalpha("images/settings_circle1.png");
      settingscircle2 = lataapngalpha("images/settings_circle2.png");
      settingsline1 = lataapngalpha("images/settings_line1.png");
      settingsline2 = lataapngalpha("images/settings_line2.png");
      settingsoff1 = lataapngalpha("images/settings_off1.png");
      settingsoff2 = lataapngalpha("images/settings_off2.png");
      settingson1 = lataapngalpha("images/settings_on1.png");
      settingson2 = lataapngalpha("images/settings_on2.png");
      //tutorial
      tutorialnuoli = lataapngalpha("images/tutorialarrow.png");
      
      latausruutu(10);   // LATAUSRUUTU
      
               //GENEROIDAAN KUVIA
      //thtin
      float tahtainetaisyys;
      float tahtainkirkkaus;
      float latausmaara = 0;
      SDL_Rect tahtainpistekohta;
      //thtimen kokokerroin on 3, eli joka indeksill thtimen pituudet suurenevat 3 pikseli
      for(i=0;i<110;i++) {
               SDL_Surface *tahtaintempkuva; //tm vhent muistin varaamista pelin latauksessa
               tahtaintempkuva = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, i * 3 + 4, i * 3 + 4, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
               for(j=i*3+4;j>0;j--) {
                        for(k=i*3+4;k>0;k--) {
                                 float a = i * (3.0 / 2.0); //jos thtimen kokokerroin on 2, tt ei tarvita
                                 tahtainetaisyys = sqrt((j - a - 2) * (j - a - 2) + (k - a - 2) * (k - a - 2));
                                 tahtainkirkkaus = round(1 / (a - tahtainetaisyys) * 300);
                                 latausmaara+= 0.00002;
                                 if(tahtainkirkkaus > 255) {
                                          SDL_SetAlpha(reddot, SDL_SRCALPHA, 255);
                                          tahtainpistekohta.x = k;
                                          tahtainpistekohta.y = j;
                                          SDL_BlitSurface(reddot, NULL, tahtaintempkuva, &tahtainpistekohta);
                                 }
                                 else if(tahtainkirkkaus > 128) {
                                          SDL_SetAlpha(reddot, SDL_SRCALPHA, int(tahtainkirkkaus));
                                          tahtainpistekohta.x = k;
                                          tahtainpistekohta.y = j;
                                          SDL_BlitSurface(reddot, NULL, tahtaintempkuva, &tahtainpistekohta);
                                 }
                        }
               }
               //tehdn smoothit ja optimoidaan
               tahtain[i] = optimoialpha(rotozoomSurface(tahtaintempkuva, 45, 1, 1));
               SDL_FreeSurface(tahtaintempkuva);
               
               while(latausmaara > 1) { latausruutu(1); latausmaara--; }   // LATAUSRUUTU
      }
      
      //statspalkit
      Uint32 palkkivari;
      SDL_Rect palkkikohta;
      for(i=0;i<225;i++) {
               SDL_Surface *temppalkki = SDL_CreateRGBSurface( SDL_HWSURFACE, 2 * (i + 1), 30, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
               //tytetn
               palkkivari = SDL_MapRGB(temppalkki->format, int(round(0.8 * (i + 1))), int(round(0.8 * (i + 1))), int(round(210 + 0.2 * (i + 1))));
               SDL_FillRect(temppalkki, NULL, palkkivari);
               //reunat
               palkkivari = SDL_MapRGB(temppalkki->format, 0, 0, 0);
               palkkikohta.x = 0;
               palkkikohta.y = 0;
               palkkikohta.w = 2 * (i + 1);
               palkkikohta.h = 2;
               SDL_FillRect(temppalkki, &palkkikohta, palkkivari);
               palkkikohta.y = 28;
               SDL_FillRect(temppalkki, &palkkikohta, palkkivari);
               palkkikohta.y = 0;
               palkkikohta.w = 2;
               palkkikohta.h = 30;
               SDL_FillRect(temppalkki, &palkkikohta, palkkivari);
               palkkikohta.x = 2 * (i + 1) - 2;
               SDL_FillRect(temppalkki, &palkkikohta, palkkivari);
               //optimoidaan
               statspalkki[i] = optimoi(temppalkki);
      }
      
      latausruutu(6);   // LATAUSRUUTU
      
      //levelipalkki
      Uint32 levelipalkkivari;
      for(i=0;i<130;i++) {
               SDL_Surface *temppalkki = SDL_CreateRGBSurface( SDL_HWSURFACE, (i + 1), 30, 32, 0xff000000,0x00ff0000,0x0000ff00,0x00000000);
               //tytetn
               levelipalkkivari = SDL_MapRGB(temppalkki->format, 0, 0, 255);
               SDL_FillRect(temppalkki, NULL, levelipalkkivari);
               //optimoidaan
               levelipalkki[i] = optimoi(temppalkki);
               //alpha
               SDL_SetAlpha(levelipalkki[i], SDL_SRCALPHA, 64);
      }
      
      latausruutu(4);   // LATAUSRUUTU
      
      //tykki
      for(i=0;i<=45;i++) tykki[i] = rotozoomSurface(tykkikuva1, 4 * i - 90, 1, 1);
      for(i=0;i<3;i++) tykkitulikuva1[i][1] = zoomSurface(tykkitulikuva1[i][0], -1, 1, 0); //flipataan
      for(i=0;i<3;i++) {
                for(j=0;j<2;j++) {
                       for(k=0;k<=45;k++) tykkituli[i][j][k] = rotozoomSurface(tykkitulikuva1[i][j], 4 * k - 90, 1, 1);
                }
      }
      
      latausruutu(3);   // LATAUSRUUTU
      
      //panos
      for(i=0;i<=45;i++) panos[i] = rotozoomSurface(panoskuva, 4 * i - 90, 1, 1);
      for(i=0;i<=45;i++) panoscrit[i] = rotozoomSurface(panoscritkuva, 4 * i - 90, 1, 1);
      
      //efektit
      for(i=0;i<5;i++) efektikuvakeltainen[i] = zoomSurface(efektikuvakeltainen2, 0.2 * (i + 1), 0.2 * (i + 1), 1);
      for(i=0;i<5;i++) efektikuvapunainen[i] = zoomSurface(efektikuvapunainen2, 0.2 * (i + 1), 0.2 * (i + 1), 1);
      
      latausruutu(1);   // LATAUSRUUTU
      
      //vihu
      for(i=0;i<4;i++) {
                for(j=0;j<5;j++) vihukuva[i][j] = zoomSurface(vihukuva2[i], vihuminkoko / 100 + j * (vihukokokerroin / 100), vihuminkoko / 100 + j * (vihukokokerroin / 100), 1);
      }
      for(i=0;i<5;i++) { //keltainen ja nopea
                for(j=0;j<10;j++) vihukuvakeltainen[i][j] = rotozoomSurface(vihukuva2keltainen, 36 * j, vihuminkoko / 100 + i * (vihukokokerroin / 100), 1);
                vihukuvanopea[i] = zoomSurface(vihukuva2nopea, (1 - 0.04 * i) * (vihuminkoko / 100 + 3 * (vihukokokerroin / 100)), (1 + 0.04 * i) * (vihuminkoko / 100 + 3 * (vihukokokerroin / 100)), 1); //koko: 4
      }
      
      latausruutu(2);   // LATAUSRUUTU
      
      //kuollut vihu
      for(i=0;i<5;i++) {
                for(j=0;j<5;j++) {
                       for(k=0;k<10;k++) vihukuollutkuva[i][j][k] = rotozoomSurface(vihukuollutkuva2[i], 36 * k, vihuminkoko / 100 + j * (vihukokokerroin / 100), 1);
                }
      }
      for(i=0;i<10;i++) { //musta ja nopea
                        vihukuollutkuvamusta[i] = rotozoomSurface(vihukuollutkuva2musta, 36 * i - 110, 1, 1);
                        vihukuollutkuvanopea[i] = rotozoomSurface(vihukuollutkuva2nopea, 36 * i - 110, vihuminkoko / 100 + 3 * (vihukokokerroin / 100), 1);
      }
      
      latausruutu(2);   // LATAUSRUUTU
      
      //vihu splatter
      for(i=0;i<5;i++) {
                for(j=0;j<5;j++) {
                       for(k=0;k<5;k++) {
                              for(l=0;l<30;l++) {
                                     SDL_Surface *splattertempkuva; //tm vhent muistin varaamista pelin latauksessa
                                     splattertempkuva = zoomSurface(splatterkuva2[i], (2 - 0.2 * k) * (vihuminkoko / 100 + j * (vihukokokerroin / 100)), (0.075 * k + 0.5) * (vihuminkoko / 100 + j * (vihukokokerroin / 100)), 1);
                                     splatterkuva[i][j][k][l] = rotozoomSurface(splattertempkuva, 12 * l, 1, 1);
                                     SDL_FreeSurface(splattertempkuva);
                               }
                        }
                }
      }
      latausruutu(4);   // LATAUSRUUTU
      for(i=0;i<5;i++) { //musta ja nopea
                for(j=0;j<30;j++) {
                        SDL_Surface *splattertempkuva; //tm vhent muistin varaamista pelin latauksessa
                        splattertempkuva = zoomSurface(splatterkuva2musta, (2 - 0.2 * i) * (1 - 2 * (vihukokokerroin / 100)), (0.075 * i + 0.5) * (1 - 2 * (vihukokokerroin / 100)), 1);
                        splatterkuvamusta[i][j] = rotozoomSurface(splattertempkuva, 12 * j, 1, 1);
                        SDL_FreeSurface(splattertempkuva);
                        splattertempkuva = zoomSurface(splatterkuva2nopea, (2 - 0.2 * i) * (vihuminkoko / 100 + 3 * (vihukokokerroin / 100)), (0.075 * i + 0.5) * (vihuminkoko / 100 + 3 * (vihukokokerroin / 100)), 1);
                        splatterkuvanopea[i][j] = rotozoomSurface(splattertempkuva, 12 * j, 1, 1);
                        SDL_FreeSurface(splattertempkuva);
                }
      }
      
      latausruutu(4);   // LATAUSRUUTU
      
               //VAPAUTETAAN TARPEETTOMIA TASOJA
      SDL_FreeSurface(lataus);
      SDL_FreeSurface(latauspalkki);
      SDL_FreeSurface(tykkikuva1);
      for(i=0;i<3;i++) {
                       for(j=0;j<2;j++) SDL_FreeSurface(tykkitulikuva1[i][j]);
      }
      SDL_FreeSurface(panoskuva);
      SDL_FreeSurface(panoscritkuva);
      SDL_FreeSurface(efektikuvakeltainen2);
      SDL_FreeSurface(efektikuvapunainen2);
      for(i=0;i<4;i++) SDL_FreeSurface(vihukuva2[i]);
      SDL_FreeSurface(vihukuva2keltainen);
      SDL_FreeSurface(vihukuva2nopea);
      for(i=0;i<5;i++) SDL_FreeSurface(vihukuollutkuva2[i]);
      SDL_FreeSurface(vihukuollutkuva2musta);
      SDL_FreeSurface(vihukuollutkuva2nopea);
      for(i=0;i<5;i++) SDL_FreeSurface(splatterkuva2[i]);
      SDL_FreeSurface(splatterkuva2musta);
      SDL_FreeSurface(splatterkuva2nopea);
      SDL_FreeSurface(nappitakaisin2);
      SDL_FreeSurface(nappiscores2);
      SDL_FreeSurface(statscontinue2);
      SDL_FreeSurface(tutorialcontinue2);
      SDL_FreeSurface(nappimored2);
      SDL_FreeSurface(nappimoreu2);
      SDL_FreeSurface(stageyes2);
      SDL_FreeSurface(stageno2);
      SDL_FreeSurface(stageok2);
      SDL_FreeSurface(newhspalkki);
      SDL_FreeSurface(newhsteksti);
      
      latausruutu(1);   // LATAUSRUUTU
      log("Game loaded");
      
      splashruutu();
      
      
      //SIIRRYTN PELIIN
      while(!kokonaanpois) {
                  short int kasautuminen = 0;
                  
                  //aina menun kautta muualle
                  if(menuvalinta == 0) menu(1000);
                  else if(menuvalinta != 1 && menuvalinta != 100) menu(0);
                  else kasautuminen = 100;
                  
                  if(menuvalinta == 1) newgame(kasautuminen);
                  
                  //if(menuvalinta == 2) naytahiscoret(false);
                  
                  if(menuvalinta == 3) asetusruutu();
                  
                  if(menuvalinta == 4) tekijat();
                  
                  if(menuvalinta == 10) staget();
                  
                  if(menuvalinta == 11) survival();
                  
                  if(menuvalinta == 12) custommap();
                  
                  if(menuvalinta == 100) pelilooppi();
                  
                  if(menuvalinta == 101) gameoverf(true);
                  
                  if(menuvalinta == 102) stats(true);
                  
                  if(menuvalinta == 103) newhiscore();
                  
                  if(menuvalinta == 104) naytahiscoret(true);
                  
                  if(menuvalinta == 105) gameoverf(false);
                  
                  if(menuvalinta == 106) stats(false);
                  
                  if(menuvalinta == 107) stageloppu();
      }
      
      
      //nytetn viel vhn valkoista ruutua
      log("\nClosing game");
      SDL_FillRect(ruutu, NULL, valkoinen);
      SDL_Flip(ruutu);
      SDL_Delay(100);


      //OHJELMA SULKEUTUU
    Mix_CloseAudio();
    SDL_Quit();
    log("Game closed");
    #ifndef _WIN32
           fclose(logtiedosto);
    #endif
    return 0;
}
