/*


    Evolute version 0.7
    Copyright (C) 2010 Antti Vainio

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.


*/

//          tekstifunktiot.cpp

#include <stdlib.h>
#include <math.h>
#include "global.hpp"

//piirretn teksti ruudulle
//int tasaus: 0 = vasemmalle, 1 = keskelle, 2 = oikealle
void piirrateksti(const char *teksti, const float kohtax, const float kohtay, const short int fonttivalinta, const short int tasaus) {
     short int t = 0;
     char teksti2[100];
     sprintf(teksti2, "%s", teksti);
     //lasketaan kirjainten lukumr
     while(teksti2[t] != '\0') t++;
     SDL_Rect kirjainkohta;
     SDL_Rect piirtokohta2;
     if(fonttivalinta == 0) {
                      kirjainkohta.w = 29;
                      kirjainkohta.h = 48;
     }
     else if(fonttivalinta == 1) {
                      kirjainkohta.w = 19;
                      kirjainkohta.h = 31;
     }
     else if(fonttivalinta == 2) {
                      kirjainkohta.w = 7;
                      kirjainkohta.h = 12;
     }
     else if(fonttivalinta == 3) {
                      kirjainkohta.w = 10;
                      kirjainkohta.h = 17;
     }
     piirtokohta2.y = int(round(kohtay));
     for(int i=t;i>0;i--) {
             switch(teksti[t - i]) {
                            case 'A':
                                 kirjainkohta.x = 0;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'B':
                                 kirjainkohta.x = kirjainkohta.w * 1;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'C':
                                 kirjainkohta.x = kirjainkohta.w * 2;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'D':
                                 kirjainkohta.x = kirjainkohta.w * 3;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'E':
                                 kirjainkohta.x = kirjainkohta.w * 4;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'F':
                                 kirjainkohta.x = kirjainkohta.w * 5;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'G':
                                 kirjainkohta.x = kirjainkohta.w * 6;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'H':
                                 kirjainkohta.x = kirjainkohta.w * 7;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'I':
                                 kirjainkohta.x = kirjainkohta.w * 8;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'J':
                                 kirjainkohta.x = kirjainkohta.w * 9;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'K':
                                 kirjainkohta.x = kirjainkohta.w * 10;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'L':
                                 kirjainkohta.x = kirjainkohta.w * 11;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'M':
                                 kirjainkohta.x = kirjainkohta.w * 12;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'N':
                                 kirjainkohta.x = kirjainkohta.w * 13;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'O':
                                 kirjainkohta.x = kirjainkohta.w * 14;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'P':
                                 kirjainkohta.x = kirjainkohta.w * 15;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'Q':
                                 kirjainkohta.x = kirjainkohta.w * 16;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'R':
                                 kirjainkohta.x = kirjainkohta.w * 17;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'S':
                                 kirjainkohta.x = kirjainkohta.w * 18;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'T':
                                 kirjainkohta.x = kirjainkohta.w * 19;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'U':
                                 kirjainkohta.x = kirjainkohta.w * 20;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'V':
                                 kirjainkohta.x = kirjainkohta.w * 21;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'W':
                                 kirjainkohta.x = kirjainkohta.w * 22;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'X':
                                 kirjainkohta.x = kirjainkohta.w * 23;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'Y':
                                 kirjainkohta.x = kirjainkohta.w * 24;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'Z':
                                 kirjainkohta.x = kirjainkohta.w * 25;
                                 kirjainkohta.y = 0;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 26;
                                 kirjainkohta.y = 0;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 27;
                                 kirjainkohta.y = 0;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 28;
                                 kirjainkohta.y = 0;
                                 break;
                            case 'a':
                                 kirjainkohta.x = 0;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'b':
                                 kirjainkohta.x = kirjainkohta.w * 1;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'c':
                                 kirjainkohta.x = kirjainkohta.w * 2;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'd':
                                 kirjainkohta.x = kirjainkohta.w * 3;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'e':
                                 kirjainkohta.x = kirjainkohta.w * 4;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'f':
                                 kirjainkohta.x = kirjainkohta.w * 5;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'g':
                                 kirjainkohta.x = kirjainkohta.w * 6;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'h':
                                 kirjainkohta.x = kirjainkohta.w * 7;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'i':
                                 kirjainkohta.x = kirjainkohta.w * 8;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'j':
                                 kirjainkohta.x = kirjainkohta.w * 9;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'k':
                                 kirjainkohta.x = kirjainkohta.w * 10;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'l':
                                 kirjainkohta.x = kirjainkohta.w * 11;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'm':
                                 kirjainkohta.x = kirjainkohta.w * 12;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'n':
                                 kirjainkohta.x = kirjainkohta.w * 13;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'o':
                                 kirjainkohta.x = kirjainkohta.w * 14;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'p':
                                 kirjainkohta.x = kirjainkohta.w * 15;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'q':
                                 kirjainkohta.x = kirjainkohta.w * 16;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'r':
                                 kirjainkohta.x = kirjainkohta.w * 17;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 's':
                                 kirjainkohta.x = kirjainkohta.w * 18;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 't':
                                 kirjainkohta.x = kirjainkohta.w * 19;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'u':
                                 kirjainkohta.x = kirjainkohta.w * 20;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'v':
                                 kirjainkohta.x = kirjainkohta.w * 21;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'w':
                                 kirjainkohta.x = kirjainkohta.w * 22;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'x':
                                 kirjainkohta.x = kirjainkohta.w * 23;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'y':
                                 kirjainkohta.x = kirjainkohta.w * 24;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case 'z':
                                 kirjainkohta.x = kirjainkohta.w * 25;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 26;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 27;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case '':
                                 kirjainkohta.x = kirjainkohta.w * 28;
                                 kirjainkohta.y = kirjainkohta.h * 1;
                                 break;
                            case ' ':
                                 kirjainkohta.x = kirjainkohta.w * 27;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '\n': //sama kuin vli
                                 kirjainkohta.x = kirjainkohta.w * 27;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '\r': //sama kuin vli - Linuxia varten
                                 kirjainkohta.x = kirjainkohta.w * 27;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '1':
                                 kirjainkohta.x = 0;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '2':
                                 kirjainkohta.x = kirjainkohta.w * 1;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '3':
                                 kirjainkohta.x = kirjainkohta.w * 2;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '4':
                                 kirjainkohta.x = kirjainkohta.w * 3;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '5':
                                 kirjainkohta.x = kirjainkohta.w * 4;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '6':
                                 kirjainkohta.x = kirjainkohta.w * 5;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '7':
                                 kirjainkohta.x = kirjainkohta.w * 6;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '8':
                                 kirjainkohta.x = kirjainkohta.w * 7;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '9':
                                 kirjainkohta.x = kirjainkohta.w * 8;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '0':
                                 kirjainkohta.x = kirjainkohta.w * 9;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '.':
                                 kirjainkohta.x = kirjainkohta.w * 10;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case ',':
                                 kirjainkohta.x = kirjainkohta.w * 11;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case ':':
                                 kirjainkohta.x = kirjainkohta.w * 12;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '!':
                                 kirjainkohta.x = kirjainkohta.w * 13;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '?':
                                 kirjainkohta.x = kirjainkohta.w * 14;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '"':
                                 kirjainkohta.x = kirjainkohta.w * 15;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '\'':
                                 kirjainkohta.x = kirjainkohta.w * 16;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '-':
                                 kirjainkohta.x = kirjainkohta.w * 17;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case '(':
                                 kirjainkohta.x = kirjainkohta.w * 18;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            case ')':
                                 kirjainkohta.x = kirjainkohta.w * 19;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
                            default:
                                 kirjainkohta.x = kirjainkohta.w * 28;
                                 kirjainkohta.y = kirjainkohta.h * 2;
                                 break;
             }
             if(tasaus == 0) piirtokohta2.x = int(round(kohtax)) + (t - i) * kirjainkohta.w;
             else if(tasaus == 1) piirtokohta2.x = int(round(kohtax - 0.5 * t * kirjainkohta.w)) + (t - i) * kirjainkohta.w;
             else piirtokohta2.x = int(round(kohtax)) - kirjainkohta.w * i;
             SDL_BlitSurface(fontti[fonttivalinta],&kirjainkohta,piirtokohta,&piirtokohta2);
     }
}

//Piirretn desimaaliluku tiettyyn kohtaan - tm funktio on lhinn debug tarkoituksiin, kun halutaan tiet jonkun muuttujan arvo
//Piirt 2 desimaalia - enintn 7 merkitsev numeroa - ei nyt aivan oikein, jos luku < 1
void piirrafloatluku(float luku, const short int kohtax, const short int kohtay) {
     SDL_Surface *tempkuvaluku;
     tempkuvaluku = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, 70, 10, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
     short int t = 0;
     char luku2[10];
     sprintf(luku2, "%.0f", luku * 100);
     SDL_Rect numerokohta;
     SDL_Rect kuvakohta;
     SDL_Rect temppiirtokohta;
     numerokohta.y = 0;
     numerokohta.w = 7;
     numerokohta.h = 10;
     kuvakohta.y = 0;
     temppiirtokohta.x = kohtax;
     temppiirtokohta.y = kohtay;
     //lasketaan kirjainten lukumr
     while(luku2[t] != '\0') t++;
     for(int i=t;i>0;i--) {
             if(i == 3) {
                  //piirretn desimaali"pilkku"
                  numerokohta.x = 70;
                  kuvakohta.x = (t - i) * 7 + 4;
                  SDL_BlitSurface(debugnumerot,&numerokohta,tempkuvaluku,&kuvakohta);
             }
             numerokohta.x = (luku2[t - i] - 48) * 7;
             kuvakohta.x = (t - i) * 7;
             SDL_BlitSurface(debugnumerot,&numerokohta,tempkuvaluku,&kuvakohta);
     }
     SDL_BlitSurface(tempkuvaluku,NULL,piirtokohta,&temppiirtokohta);
     SDL_FreeSurface(tempkuvaluku);
}

//piirretn luku ruudulle
//bool vasen kertoo, jos tasataan luku vasemmalle
void piirraluku(const int luku, const float kohtax, const float kohtay, bool vasen) {
     short int t = 0;
     char luku2[10];
     sprintf(luku2, "%i", luku);
     SDL_Rect numerokohta;
     SDL_Rect temppiirtokohta;
     numerokohta.y = 0;
     numerokohta.w = 11;
     numerokohta.h = 13;
     temppiirtokohta.y = int(round(kohtay));
     //lasketaan kirjainten lukumr
     while(luku2[t] != '\0') t++;
     for(int i=t;i>0;i--) {
             numerokohta.x = (luku2[t - i] - 48) * 11;
             if(vasen) temppiirtokohta.x = int(round(kohtax)) + (t - i) * 11;
             else temppiirtokohta.x = int(round(kohtax)) - 11 * i;
             SDL_BlitSurface(numerot,&numerokohta,piirtokohta,&temppiirtokohta);
     }
}

//tm funktio piirt expan tavoitearvot exppalkkeihin ja expat peliss oikeisiin kohtiinsa
//paikat 1-19 ovat expoille ja muille peliss, paikat 20- menevt exppalkkeihin - mik tehdn jo loadingissa
//pelin paikoille on muutama ylimrinen tulevaisuutta ajatellen
void piirraexpluku(const int luku, const short int paikka) {
     SDL_Surface *tempkuvaluku;
     tempkuvaluku = SDL_CreateRGBSurface( SDL_HWSURFACE | SDL_SRCALPHA, 75, 13, 32, 0xff000000,0x00ff0000,0x0000ff00,0x000000ff);
     short int t = 0;
     char luku2[10];
     if(paikka == 9 && luku < 10) sprintf(luku2, "0%i", luku); //listn sekuntien alkuu 0, jos se on < 10
     else sprintf(luku2, "%i", luku);
     SDL_Rect numerokohta;
     SDL_Rect kuvakohta;
     SDL_Rect temppiirtokohta;
     numerokohta.y = 0;
     numerokohta.w = 11;
     numerokohta.h = 13;
     kuvakohta.y = 0;
     //lasketaan kirjainten lukumr
     while(luku2[t] != '\0') t++;
     if(paikka <= 5) { //expat
               if(piirtokohta == kauppakuva) {
                              temppiirtokohta.x = 82;
                              temppiirtokohta.y = 0 - 30 + paikka * 100;
               }
               else {
                              temppiirtokohta.x = 22;
                              temppiirtokohta.y = 18 + paikka * 100;
               }
     }
     else if(paikka == 6) { //pisteet
               temppiirtokohta.x = 780 - t * 11;
               temppiirtokohta.y = 118;
     }
     else if(paikka == 7) { //fps
               temppiirtokohta.x = 694 - t * 11;
               temppiirtokohta.y = 168;
     }
     else if(paikka == 8) { //minuutit
               temppiirtokohta.x = 724 - t * 11;
               temppiirtokohta.y = 218;
     }
     else if(paikka == 9) { //sekuntit
               temppiirtokohta.x = 754 - t * 11;
               temppiirtokohta.y = 218;
     }
     else { //expatavoitteet exppalkkeihin
               temppiirtokohta.x = 71 + (5 - t) * 11;
               temppiirtokohta.y = 9;
     }
     for(int i=t;i>0;i--) {
             numerokohta.x = (luku2[t - i] - 48) * 11;
             kuvakohta.x = (t - i) * 11;
             //piirretn huono FPS punaisena
             if(paikka == 7 && luku < 40) SDL_BlitSurface(expnumerot_red,&numerokohta,tempkuvaluku,&kuvakohta);
             else SDL_BlitSurface(expnumerot,&numerokohta,tempkuvaluku,&kuvakohta);
     }
     if(paikka < 20) SDL_BlitSurface(tempkuvaluku,NULL,piirtokohta,&temppiirtokohta);
     else SDL_BlitSurface(tempkuvaluku,NULL,exppalkki[paikka - 20],&temppiirtokohta);
     SDL_FreeSurface(tempkuvaluku);
}

//piirt explisyskuvan
void piirraexplisays(float luku, const float kohtax, const float kohtay) {
     if(luku == -1) piirrakuva(expnumerot_1, kohtax + 16, kohtay);
     else if(kohtay != 525 && luku == 100) piirrakuva(expnumerot_100, kohtax + 24, kohtay);
     else if(luku == 400) piirrakuva(expnumerot_400, kohtax + 24, kohtay);
     else {
          short int t;
          SDL_Rect temppiirtokohta;
          SDL_Rect tempkuvakohta;
          temppiirtokohta.x = int(round(kohtax));
          temppiirtokohta.y = int(round(kohtay - 6));
          tempkuvakohta.x = 110;
          tempkuvakohta.y = 0;
          tempkuvakohta.w = 11;
          tempkuvakohta.h = 12;
          if(luku <= 9) t = 1;
          else if(luku > 9 && luku <= 99) t = 2;
          else t = 3;
          SDL_BlitSurface(expnumerot2, &tempkuvakohta, piirtokohta, &temppiirtokohta);
          for(int i=1;i<=t;i++) {
               tempkuvakohta.x = int(floor(luku / pow(10, (t - i))) * 11);
               temppiirtokohta.x = int(round(kohtax + i * 11));
               SDL_BlitSurface(expnumerot2, &tempkuvakohta, piirtokohta, &temppiirtokohta);
               luku = luku - floor(luku / (pow(10, (t - i)))) * pow(10, (t - i));
          }
     }
}
